﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Chapitre_11_Server
{
    class KeyboardService : GameComponent, IKeyboardService
    {
        KeyboardState lastKBState;
        KeyboardState KBState;

        public KeyboardService(Game game)
            : base(game)
        {
            ServiceHelper.Add<IKeyboardService>(this);
        }

        public bool IsKeyDown(Keys key)
        {
            return KBState.IsKeyDown(key);
        }

        public bool KeyHasBeenPressed(Keys key)
        {
            return lastKBState.IsKeyDown(key) && KBState.IsKeyUp(key);
        }

        public override void Update(GameTime gameTime)
        {
            lastKBState = KBState;
            KBState = Keyboard.GetState();
            base.Update(gameTime);
        }
    }
}
